#pragma once
#include "SFML\Graphics.hpp"
#include "Input.h"
#include "Animation.h"

class MySprite : public sf::RectangleShape
{
public:
	MySprite();
	~MySprite();

	enum SpriteType	//SpriteType enum allows us to check the type of every sprite and cast it to the correct type if we need to access member functions
	{
		MarioSprite,
		GoombaSprite,
		KoopaSprite,
		BlockSprite,
		CoinSprite,
		PipeSprite,
		MushroomSprite,
		OneUpSprite,
		PoleSprite,
		FlagSprite,
		CastleSprite,
		CloudSprite,
		BushSprite,
		HillSprite
	};

	virtual void update(float dt);	//virtual update function that can be overidden by each sprite to update its respective behaviour/elements

	// sprite speed and direction
	void setVelocity(sf::Vector2f vel);
	void setVelocity(float vx, float vy);
	sf::Vector2f getVelocity();

	// sprite state
	bool isAlive() { return alive; };
	void setAlive(bool b) { alive = b; };

	// for sprite collision
	bool isCollider() { return collider; };
	void setCollider(bool b) { collider = b; };
	sf::FloatRect getCollisionBox();
	void setCollisionBox(float x, float y, float width, float height) { collisionBox = sf::FloatRect(x, y, width, height); };
	void setCollisionBox(sf::FloatRect fr) { collisionBox = fr; };
	virtual void collisionResponse(MySprite* sp);

	// input component
	void setInput(Input* in) { input = in; };

	bool getInvincible();	//Get whether or not the sprite is currently invincible
	void setInvincible(bool val, float duration);	//Set the sprite's invincibility to be val for duration seconds

	bool getAirbourne();	//Get whether or not the sprite is currently airbourne
	void setAirbourne(bool air);	//Set the sprite's airbourne to be air

	float getInvincibilityTime();

	SpriteType getSpriteType();	//getSpriteType returns the SpriteType of this sprite (most commonly used for knowing what to cast MySprite to)

protected:
	// Sprite properties
	sf::Vector2f velocity;
	bool alive;

	// Collision vars
	sf::FloatRect collisionBox;
	bool collider;

	// input component
	Input* input;

	float scale;	//
	float gravity;	//		Declared here so all sprites share the same scale and gravity initially, but can be overridden if necessary

	SpriteType spriteType;	//SpriteType varaible spriteType stores what type of sprite this is

private:
	bool isInvincible;	//bool to store whether or not the sprite is invincible
	bool isAirbourne;	//bool to store whether or not the sprite is airbourne
	float invincibilityTime;
};